<?php $__env->startSection('content'); ?>
    <div class="container-fluid mb-2">
        <?php if($message = Session::get('success')): ?>
            <div class="col-lg-6 alert alert-success" id="successMessage">
                <p><?php echo e($message); ?></p>
            </div>
        <?php endif; ?>
        <div class="row justify-content-center">
            <div class="row p-3">
                <div class="col-lg-6">
                    <h4 class="pt-2">
                        <?php if(count($catalogs) > 0): ?>
                            Product List
                        <?php else: ?>
                            There are no data to show
                        <?php endif; ?>
                    </h4>
                </div>
                <div class="col-lg-6 d-flex justify-content-end align-items-center">
                    <span style="float:right;"><a href="<?php echo e(route('product.trash')); ?>" class="btn btn-warning shadow-none">Go
                            To
                            Trash</a>
                    </span>
                    <span style="float:right;"><a href="<?php echo e(route('product.create')); ?>"
                            class="btn btn-primary shadow-none ms-2">Add
                            Product</a>
                    </span>
                </div>
            </div>
            <?php if(count($catalogs) !== 0): ?>
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr class="text-center">
                                <th>ID</th>
                                <th>Catalog Name</th>
                                <th>Main Image</th>
                                <th>Action</th>
                                <th>Product</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $catalogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $catalog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="text-center">
                                    <td><?php echo e($catalog->id); ?></td>
                                    <td><?php echo e($catalog->title); ?></td>
                                    <td><img src="<?php echo e(asset('images/catalog/' . $catalog->main_image)); ?>" width="50"
                                            height="50">
                                    </td>
                                    <td>
                                        <div class="d-flex gap-2 justify-content-center">
                                            <div>
                                                <a href="<?php echo e(route('catalog.edit', $catalog->id)); ?>"
                                                    class="btn btn-primary btn-sm shadow-none">Edit</a>
                                            </div>
                                            <div>
                                                <button class="delete-user btn btn-danger btn-sm shadow-none"
                                                    data-id="<?php echo e($catalog->id); ?>">Delete </button>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex gap-2 justify-content-center flex-nowrap">
                                            <?php $__currentLoopData = $catalog->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                
                                                <div>
                                                    <a href="<?php echo e(route('product.edit', $product->id)); ?>"
                                                        class="btn btn-secondary btn-sm shadow-none">
                                                        
                                                        <?php echo e($product->color); ?>

                                                    </a>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <?php echo $catalogs->withQueryString()->links('pagination::bootstrap-5'); ?>


    <script>
        const deleteButtons = document.querySelectorAll('.delete-user');

        deleteButtons.forEach(button => {
            button.addEventListener('click', (e) => {
                e.preventDefault();
                const userId = e.target.getAttribute('data-id');

                Swal.fire({
                    title: 'Are you sure?',
                    text: 'You won\'t be able to revert this!',
                    icon: 'warning', //question , error , warning , success , info

                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Redirect to a route that handles user deletion
                        window.location.href = `/catalog/delete/${userId}`;
                        Swal.fire('Deleted!', 'Deleted Successfully.', 'success');
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\flipcode\laravel\MSOnline(UmangBhai)\resources\views/product/index.blade.php ENDPATH**/ ?>