<?php $__env->startSection('content'); ?>
    
    <div class="container">
        <?php if($message = Session::get('success')): ?>
            <div class="col-lg-6 alert alert-success" id="successMessage">
                <p><?php echo e($message); ?></p>
            </div>
        <?php endif; ?>
        <div class="row justify-content-center">
            <div class="col-md-12">
                <h2 class="text-center">Hello, Admin</h2>
                <!-- ======= Dashboard ======= -->
                <section id="dashboard" class="dashboard">
                    <?php if($catalogs == null): ?>
                    <div class="row">
                        <!-- Out-of-Stock Products -->
                        <div class="col-lg-12">
                            <div class="card-body mb-2">
                                <h5 class="card-title">Out-of-Stock Products</h5>
                                <table class="table table-bordered text-center">
                                    <thead>
                                        <tr>
                                            <th>Catalog Name</th>
                                            <th>Product Name</th>
                                            <th>Quantity</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $catalogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $catalog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php $__currentLoopData = $catalog->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php $__currentLoopData = $product->productStocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($stock->quantity <= 10): ?>
                                                        <tr>
                                                            <td><?php echo e($catalog->title); ?></td>
                                                            <td><?php echo e($product->slug); ?></td>
                                                            <td><?php echo e($stock->quantity); ?></td>
                                                            <td>
                                                                <div class="d-flex gap-2 justify-content-center">
                                                                    <div>
                                                                        <a href="<?php echo e(route('product-stock.edit', $stock->id)); ?>"
                                                                            class="btn btn-primary btn-sm shadow-none mb-2">Edit</a>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php echo $catalogs->withQueryString()->links('pagination::bootstrap-5'); ?>

                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="row">
                        <!-- Recent Orders -->
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title">Recent Orders</h5>
                                    <?php if(count($orders) !== 0): ?>
                                        <table id="slider-table" class="table table-bordered text-center">
                                            <thead class="">
                                                <tr>
                                                    <th>No</th>
                                                    <th>User Name</th>
                                                    <th>Address</th>
                                                    <th>Payment ID</th>
                                                    <th>Product Name</th>
                                                    <th>Quantity</th>
                                                    <th>Order Status</th>
                                                    <th>Price</th>
                                                    <th>Total Amount</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($loop->iteration); ?></td>
                                                        <td><?php echo e($order->order->users->name ?? '-'); ?></td>
                                                        <td><?php echo e($order->customer_address ?? '-'); ?></td>
                                                        <td><?php echo e($order->order->payment_id ?? '-'); ?></td>
                                                        <td><?php echo e($order->product->slug ?? '-'); ?></td>
                                                        <td><?php echo e($order->quantity ?? '-'); ?></td>
                                                        <td>
                                                            <?php echo e($order->orderStatus ?? '-'); ?>

                                                        </td>
                                                        
                                                        <td><?php echo e($order->price ?? '-'); ?></td>
                                                        <td><?php echo e($order->order->amount ?? '-'); ?></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>


                   
                </section>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\flipcode\laravel\MSOnline(UmangBhai)\resources\views/adminHome.blade.php ENDPATH**/ ?>